/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.hyperschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.uritemplate.URITemplate;
import com.github.fge.uritemplate.URITemplateParseException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public final class LinksSyntaxChecker
extends AbstractSyntaxChecker {
    private static final ImmutableList<String> REQUIRED_LDO_PROPERTIES = ImmutableList.of("href", "rel");
    private static final SyntaxChecker INSTANCE = new LinksSyntaxChecker();

    private LinksSyntaxChecker() {
        super("links", NodeType.ARRAY, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        int size2 = node.size();
        for (int index = 0; index < size2; ++index) {
            JsonNode ldo = this.getNode(tree).get(index);
            NodeType type2 = NodeType.getNodeType(ldo);
            if (type2 != NodeType.OBJECT) {
                report.error(this.LDOMsg(tree, bundle, "draftv4.ldo.incorrectType", index).put("expected", NodeType.OBJECT).putArgument("found", type2));
                continue;
            }
            HashSet<String> set2 = Sets.newHashSet(ldo.fieldNames());
            ArrayList<String> list = Lists.newArrayList(REQUIRED_LDO_PROPERTIES);
            list.removeAll(set2);
            if (!list.isEmpty()) {
                ProcessingMessage msg = this.LDOMsg(tree, bundle, "draftv4.ldo.missingRequired", index);
                report.error(msg.put("required", REQUIRED_LDO_PROPERTIES).putArgument("missing", list));
                continue;
            }
            if (ldo.has("schema")) {
                pointers.add(JsonPointer.of(this.keyword, index, "schema"));
            }
            if (ldo.has("targetSchema")) {
                pointers.add(JsonPointer.of(this.keyword, index, "targetSchema"));
            }
            this.checkLDO(report, bundle, tree, index);
        }
    }

    private void checkLDO(ProcessingReport report, MessageBundle bundle, SchemaTree tree, int index) throws ProcessingException {
        String value2;
        JsonNode ldo = this.getNode(tree).get(index);
        this.checkLDOProperty(report, bundle, tree, index, "rel", NodeType.STRING, "draftv4.ldo.rel.incorrectType");
        if (this.checkLDOProperty(report, bundle, tree, index, "href", NodeType.STRING, "draftv4.ldo.href.incorrectType")) {
            value2 = ldo.get("href").textValue();
            try {
                new URITemplate(value2);
            }
            catch (URITemplateParseException ignored) {
                report.error(this.LDOMsg(tree, bundle, "draftv4.ldo.href.notURITemplate", index).putArgument("value", value2));
            }
        }
        this.checkLDOProperty(report, bundle, tree, index, "title", NodeType.STRING, "draftv4.ldo.title.incorrectType");
        if (this.checkLDOProperty(report, bundle, tree, index, "mediaType", NodeType.STRING, "draftv4.ldo.mediaType.incorrectType")) {
            value2 = ldo.get("mediaType").textValue();
            try {
                MediaType.parse(value2);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.LDOMsg(tree, bundle, "draftv4.ldo.mediaType.notMediaType", index).putArgument("value", value2));
            }
        }
        this.checkLDOProperty(report, bundle, tree, index, "method", NodeType.STRING, "draftv4.ldo.method.incorrectType");
        if (this.checkLDOProperty(report, bundle, tree, index, "encType", NodeType.STRING, "draftv4.ldo.enctype.incorrectType")) {
            value2 = ldo.get("encType").textValue();
            try {
                MediaType.parse(value2);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.LDOMsg(tree, bundle, "draftv4.ldo.enctype.notMediaType", index).putArgument("value", value2));
            }
        }
    }

    private ProcessingMessage LDOMsg(SchemaTree tree, MessageBundle bundle, String key2, int index) {
        return this.newMsg(tree, bundle, key2).put("index", index);
    }

    private boolean checkLDOProperty(ProcessingReport report, MessageBundle bundle, SchemaTree tree, int index, String name, NodeType expected, String key2) throws ProcessingException {
        JsonNode node = this.getNode(tree).get(index).get(name);
        if (node == null) {
            return false;
        }
        NodeType type2 = NodeType.getNodeType(node);
        if (type2 == expected) {
            return true;
        }
        report.error(this.LDOMsg(tree, bundle, key2, index).put("expected", expected).putArgument("found", type2));
        return false;
    }
}

