/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load.configuration;

import com.github.fge.jsonschema.core.load.download.DefaultURIDownloader;
import com.github.fge.jsonschema.core.load.download.ResourceURIDownloader;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.util.ArgumentChecker;
import com.github.fge.jsonschema.core.util.Registry;
import com.github.fge.jsonschema.core.util.URIUtils;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

final class URIDownloadersRegistry
extends Registry<String, URIDownloader> {
    private static final Map<String, URIDownloader> DEFAULT_DOWNLOADERS;

    public URIDownloadersRegistry() {
        super(URIUtils.schemeNormalizer(), URIUtils.schemeChecker(), Functions.identity(), ArgumentChecker.anythingGoes());
        this.putAll(DEFAULT_DOWNLOADERS);
    }

    @Override
    protected void checkEntry(String key2, URIDownloader value2) {
    }

    static {
        ImmutableMap.Builder<String, URIDownloader> builder = ImmutableMap.builder();
        String scheme2 = "http";
        URIDownloader downloader = DefaultURIDownloader.getInstance();
        builder.put(scheme2, downloader);
        scheme2 = "https";
        downloader = DefaultURIDownloader.getInstance();
        builder.put(scheme2, downloader);
        scheme2 = "file";
        downloader = DefaultURIDownloader.getInstance();
        builder.put(scheme2, downloader);
        scheme2 = "ftp";
        downloader = DefaultURIDownloader.getInstance();
        builder.put(scheme2, downloader);
        scheme2 = "jar";
        downloader = DefaultURIDownloader.getInstance();
        builder.put(scheme2, downloader);
        scheme2 = "resource";
        downloader = ResourceURIDownloader.getInstance();
        builder.put(scheme2, downloader);
        DEFAULT_DOWNLOADERS = builder.build();
    }
}

