/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load.uri;

import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.util.URIUtils;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class URITranslator {
    private final URI namespace;
    private final Map<URI, URI> pathRedirects;
    private final Map<URI, URI> schemaRedirects;

    public URITranslator(URITranslatorConfiguration cfg) {
        this.namespace = cfg.namespace;
        this.pathRedirects = ImmutableMap.copyOf(cfg.pathRedirects);
        this.schemaRedirects = ImmutableMap.copyOf(cfg.schemaRedirects);
    }

    public URI translate(URI source2) {
        URI uri2 = URIUtils.normalizeURI(this.namespace.resolve(source2));
        String fragment = uri2.getFragment();
        try {
            uri2 = new URI(uri2.getScheme(), uri2.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException e2) {
            throw new IllegalStateException("How did I get there??", e2);
        }
        for (Map.Entry<URI, URI> entry : this.pathRedirects.entrySet()) {
            URI relative = entry.getKey().relativize(uri2);
            if (relative.equals(uri2)) continue;
            uri2 = entry.getValue().resolve(relative);
        }
        if (this.schemaRedirects.containsKey(uri2 = JsonRef.fromURI(uri2).getLocator())) {
            uri2 = this.schemaRedirects.get(uri2);
        }
        try {
            return new URI(uri2.getScheme(), uri2.getSchemeSpecificPart(), fragment);
        }
        catch (URISyntaxException e3) {
            throw new IllegalStateException("How did I get there??", e3);
        }
    }
}

