/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.processing;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.processing.ProcessingResult;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.equivalence.Equivalences;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.base.Equivalence;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;

public final class CachingProcessor<IN extends MessageProvider, OUT extends MessageProvider>
implements Processor<IN, OUT> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final int DEFAULT_CACHE_SIZE = 512;
    private final Processor<IN, OUT> processor;
    private final Equivalence<IN> equivalence;
    private final LoadingCache<Equivalence.Wrapper<IN>, ProcessingResult<OUT>> cache;

    public CachingProcessor(Processor<IN, OUT> processor) {
        this(processor, Equivalences.equals());
    }

    public CachingProcessor(Processor<IN, OUT> processor, Equivalence<IN> equivalence) {
        this(processor, equivalence, 512);
    }

    public CachingProcessor(Processor<IN, OUT> processor, Equivalence<IN> equivalence, int cacheSize) {
        BUNDLE.checkNotNull(processor, "processing.nullProcessor");
        BUNDLE.checkNotNull(equivalence, "processing.nullEquivalence");
        BUNDLE.checkArgument(cacheSize >= -1, "processing.invalidCacheSize");
        this.processor = processor;
        this.equivalence = equivalence;
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        if (cacheSize != -1) {
            builder.maximumSize(cacheSize);
        }
        this.cache = builder.build(this.loader());
    }

    @Override
    public OUT process(ProcessingReport report, IN input) throws ProcessingException {
        ProcessingResult<OUT> result2;
        try {
            result2 = this.cache.get(this.equivalence.wrap(input));
        }
        catch (ExecutionException e2) {
            throw (ProcessingException)e2.getCause();
        }
        report.mergeWith(result2.getReport());
        return result2.getResult();
    }

    private CacheLoader<Equivalence.Wrapper<IN>, ProcessingResult<OUT>> loader() {
        return new CacheLoader<Equivalence.Wrapper<IN>, ProcessingResult<OUT>>(){

            @Override
            public ProcessingResult<OUT> load(Equivalence.Wrapper<IN> key2) throws ProcessingException {
                MessageProvider input = (MessageProvider)key2.get();
                ListProcessingReport report = new ListProcessingReport(LogLevel.DEBUG, LogLevel.NONE);
                return ProcessingResult.of(CachingProcessor.this.processor, report, input);
            }
        };
    }

    public String toString() {
        return "CACHED[" + this.processor + ']';
    }
}

