/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonschema.core.exceptions.ExceptionProvider;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.SimpleExceptionProvider;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ProcessingMessage
implements AsJson {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final Map<String, JsonNode> map = Maps.newLinkedHashMap();
    private final List<Object> args = Lists.newArrayList();
    private ExceptionProvider exceptionProvider = SimpleExceptionProvider.getInstance();
    private LogLevel level;

    public ProcessingMessage() {
        this.setLogLevel(LogLevel.INFO);
    }

    public String getMessage() {
        return this.map.containsKey("message") ? this.map.get("message").textValue() : "(no message)";
    }

    public LogLevel getLogLevel() {
        return this.level;
    }

    public ProcessingMessage setMessage(String message) {
        this.args.clear();
        return this.put("message", message);
    }

    public ProcessingMessage setLogLevel(LogLevel level) {
        BUNDLE.checkNotNull(level, "processing.nullLevel");
        this.level = level;
        return this.put("level", level);
    }

    public ProcessingMessage setExceptionProvider(ExceptionProvider exceptionProvider) {
        BUNDLE.checkNotNull(exceptionProvider, "processing.nullExceptionProvider");
        this.exceptionProvider = exceptionProvider;
        return this;
    }

    public ProcessingMessage put(String key2, JsonNode value2) {
        if (key2 == null) {
            return this;
        }
        if (value2 == null) {
            return this.putNull(key2);
        }
        this.map.put(key2, (JsonNode)value2.deepCopy());
        return this;
    }

    public ProcessingMessage putArgument(String key2, JsonNode value2) {
        this.addArgument(key2, value2);
        return this.put(key2, value2);
    }

    public ProcessingMessage put(String key2, AsJson asJson) {
        return this.put(key2, asJson.asJson());
    }

    public ProcessingMessage putArgument(String key2, AsJson asJson) {
        this.addArgument(key2, asJson.asJson());
        return this.put(key2, asJson);
    }

    public ProcessingMessage put(String key2, String value2) {
        return value2 == null ? this.putNull(key2) : this.put(key2, FACTORY.textNode(value2));
    }

    public ProcessingMessage put(String key2, int value2) {
        return this.put(key2, FACTORY.numberNode(value2));
    }

    public ProcessingMessage putArgument(String key2, int value2) {
        this.addArgument(key2, value2);
        return this.put(key2, value2);
    }

    public <T> ProcessingMessage put(String key2, T value2) {
        return value2 == null ? this.putNull(key2) : this.put(key2, FACTORY.textNode(value2.toString()));
    }

    public <T> ProcessingMessage putArgument(String key2, T value2) {
        this.addArgument(key2, value2);
        return this.put(key2, value2);
    }

    public <T> ProcessingMessage put(String key2, Iterable<T> values2) {
        if (values2 == null) {
            return this.putNull(key2);
        }
        ArrayNode node = FACTORY.arrayNode();
        for (T value2 : values2) {
            node.add(value2 == null ? FACTORY.nullNode() : FACTORY.textNode(value2.toString()));
        }
        return this.put(key2, node);
    }

    public <T> ProcessingMessage putArgument(String key2, Iterable<T> values2) {
        this.addArgument(key2, values2);
        return this.put(key2, values2);
    }

    private void addArgument(String key2, Object value2) {
        if (key2 != null) {
            this.args.add(value2);
        }
        if (!this.map.containsKey("message")) {
            return;
        }
        String fmt = this.map.get("message").textValue();
        try {
            String formatted = new Formatter().format(fmt, this.args.toArray()).toString();
            this.map.put("message", FACTORY.textNode(formatted));
        }
        catch (IllegalFormatException illegalFormatException) {
            // empty catch block
        }
    }

    private ProcessingMessage putNull(String key2) {
        if (key2 == null) {
            return this;
        }
        this.map.put(key2, FACTORY.nullNode());
        return this;
    }

    @Override
    public JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.setAll(this.map);
        return ret;
    }

    public ProcessingException asException() {
        return this.exceptionProvider.doException(this);
    }

    public String toString() {
        LinkedHashMap<String, JsonNode> tmp = Maps.newLinkedHashMap(this.map);
        JsonNode node = (JsonNode)tmp.remove("message");
        String message = node == null ? "(no message)" : node.textValue();
        StringBuilder sb = new StringBuilder().append((Object)this.level).append(": ");
        sb.append(message);
        for (Map.Entry entry : tmp.entrySet()) {
            sb.append("\n    ").append((String)entry.getKey()).append(": ").append(entry.getValue());
        }
        return sb.append('\n').toString();
    }
}

