/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.util;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DictionaryBuilder<T>
implements Thawed<Dictionary<T>> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    final Map<String, T> entries = Maps.newHashMap();

    DictionaryBuilder() {
    }

    DictionaryBuilder(Dictionary<T> dict) {
        this.entries.putAll(dict.entries);
    }

    public DictionaryBuilder<T> addEntry(String key2, T value2) {
        BUNDLE.checkNotNull(key2, "dictionary.nullKey");
        BUNDLE.checkNotNull(value2, "dictionary.nullValue");
        this.entries.put(key2, value2);
        return this;
    }

    public DictionaryBuilder<T> addAll(Dictionary<T> other) {
        BUNDLE.checkNotNull(other, "dictionary.nullDict");
        this.entries.putAll(other.entries);
        return this;
    }

    public DictionaryBuilder<T> removeEntry(String key2) {
        this.entries.remove(key2);
        return this;
    }

    @Override
    public Dictionary<T> freeze() {
        return new Dictionary(this);
    }
}

