/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.util;

import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.util.ArgumentChecker;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

@Beta
public abstract class Registry<K, V> {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final Map<K, V> map = Maps.newHashMap();
    private final Function<K, K> keyNormalizer;
    private final ArgumentChecker<K> keyChecker;
    private final Function<V, V> valueNormalizer;
    private final ArgumentChecker<V> valueChecker;

    protected Registry(Function<K, K> keyNormalizer, ArgumentChecker<K> keyChecker, Function<V, V> valueNormalizer, ArgumentChecker<V> valueChecker) {
        this.keyNormalizer = BUNDLE.checkNotNull(keyNormalizer, "mapBuilder.nullNormalizer");
        this.keyChecker = BUNDLE.checkNotNull(keyChecker, "mapBuilder.nullChecker");
        this.valueNormalizer = BUNDLE.checkNotNull(valueNormalizer, "mapBuilder.nullNormalizer");
        this.valueChecker = BUNDLE.checkNotNull(valueChecker, "mapBuilder.nullChecker");
    }

    public final Registry<K, V> put(K key2, V value2) {
        BUNDLE.checkNotNull(key2, "mapBuilder.nullKey");
        BUNDLE.checkNotNull(value2, "mapBuilder.nullValue");
        K normalizedKey = this.keyNormalizer.apply(key2);
        this.keyChecker.check(key2);
        V normalizedValue = this.valueNormalizer.apply(value2);
        this.valueChecker.check(value2);
        this.checkEntry(normalizedKey, normalizedValue);
        this.map.put(normalizedKey, normalizedValue);
        return this;
    }

    public final Registry<K, V> putAll(Map<K, V> otherMap) {
        BUNDLE.checkNotNull(otherMap, "mapBuilder.nullMap");
        for (Map.Entry<K, V> entry : otherMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public final Registry<K, V> remove(K key2) {
        this.map.remove(key2);
        return this;
    }

    public final Registry<K, V> clear() {
        this.map.clear();
        return this;
    }

    public final Map<K, V> build() {
        return ImmutableMap.copyOf(this.map);
    }

    protected abstract void checkEntry(K var1, V var2);
}

