/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.util;

import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.util.ArgumentChecker;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;

public final class URIUtils {
    private static final CharMatcher ALPHA = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).precomputed();
    private static final CharMatcher SCHEME_LEGAL = ALPHA.or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf("+-.")).precomputed();
    private static final Function<String, String> LOWERCASE = new Function<String, String>(){

        @Override
        @Nullable
        public String apply(@Nullable String input) {
            return input == null ? null : input.toLowerCase();
        }
    };
    private static final Function<URI, URI> URI_NORMALIZER = new Function<URI, URI>(){

        @Override
        @Nullable
        public URI apply(@Nullable URI input) {
            if (input == null) {
                return null;
            }
            URI uri2 = input.normalize();
            String scheme2 = uri2.getScheme();
            String host2 = uri2.getHost();
            if (scheme2 == null && host2 == null) {
                return uri2;
            }
            if (uri2.isOpaque()) {
                try {
                    return new URI((String)LOWERCASE.apply(scheme2), uri2.getSchemeSpecificPart(), uri2.getFragment());
                }
                catch (URISyntaxException e2) {
                    throw new IllegalStateException("How did I get there??", e2);
                }
            }
            String userinfo = uri2.getUserInfo();
            int port2 = uri2.getPort();
            String path2 = uri2.getPath();
            String query2 = uri2.getQuery();
            String fragment = uri2.getFragment();
            try {
                return new URI((String)LOWERCASE.apply(scheme2), userinfo, (String)LOWERCASE.apply(host2), port2, path2, query2, fragment);
            }
            catch (URISyntaxException e3) {
                throw new IllegalStateException("How did I get there??", e3);
            }
        }
    };
    private static final Function<URI, URI> SCHEMAURI_NORMALIZER = new Function<URI, URI>(){

        @Override
        @Nullable
        public URI apply(@Nullable URI input) {
            URI uri2 = (URI)URI_NORMALIZER.apply(input);
            if (uri2 == null) {
                return null;
            }
            try {
                return new URI(uri2.getScheme(), uri2.getSchemeSpecificPart(), Optional.fromNullable(uri2.getFragment()).or(""));
            }
            catch (URISyntaxException e2) {
                throw new RuntimeException("How did I get there??", e2);
            }
        }
    };
    private static final ArgumentChecker<String> SCHEME_CHECKER = new ArgumentChecker<String>(){

        @Override
        public void check(String argument) {
            if (argument.isEmpty() || !ALPHA.matches(argument.charAt(0)) || !SCHEME_LEGAL.matchesAllOf(argument)) {
                throw new IllegalArgumentException(BUNDLE.printf("loadingCfg.illegalScheme", argument));
            }
        }
    };
    private static final ArgumentChecker<URI> PATHURI_CHECKER = new ArgumentChecker<URI>(){

        @Override
        public void check(URI argument) {
            BUNDLE.checkArgumentPrintf(argument.isAbsolute(), "uriChecks.notAbsolute", argument);
            BUNDLE.checkArgumentPrintf(argument.getFragment() == null, "uriChecks.fragmentNotNull", argument);
            BUNDLE.checkArgumentPrintf(argument.getQuery() == null, "uriChecks.queryNotNull", argument);
            BUNDLE.checkArgumentPrintf(argument.getPath() != null, "uriChecks.noPath", argument);
            BUNDLE.checkArgumentPrintf(argument.getPath().endsWith("/"), "uriChecks.noEndingSlash", argument);
        }
    };
    private static final ArgumentChecker<URI> SCHEMAURI_CHECKER = new ArgumentChecker<URI>(){

        @Override
        public void check(URI argument) {
            BUNDLE.checkArgumentPrintf(argument.isAbsolute(), "uriChecks.notAbsolute", argument);
            JsonRef ref = JsonRef.fromURI(argument);
            BUNDLE.checkArgumentPrintf(ref.isAbsolute(), "uriChecks.notAbsoluteRef", argument);
            BUNDLE.checkArgumentPrintf(argument.getPath() == null || !argument.getPath().endsWith("/"), "uriChecks.endingSlash", argument);
        }
    };

    private URIUtils() {
    }

    public static Function<String, String> schemeNormalizer() {
        return LOWERCASE;
    }

    public static String normalizeScheme(@Nullable String scheme2) {
        return LOWERCASE.apply(scheme2);
    }

    public static Function<URI, URI> uriNormalizer() {
        return URI_NORMALIZER;
    }

    public static URI normalizeURI(@Nullable URI uri2) {
        return URI_NORMALIZER.apply(uri2);
    }

    public static Function<URI, URI> schemaURINormalizer() {
        return SCHEMAURI_NORMALIZER;
    }

    public static URI normalizeSchemaURI(@Nullable URI uri2) {
        return SCHEMAURI_NORMALIZER.apply(uri2);
    }

    public static ArgumentChecker<String> schemeChecker() {
        return SCHEME_CHECKER;
    }

    public static void checkScheme(String scheme2) {
        SCHEME_CHECKER.check(scheme2);
    }

    public static ArgumentChecker<URI> pathURIChecker() {
        return PATHURI_CHECKER;
    }

    public static void checkPathURI(URI uri2) {
        PATHURI_CHECKER.check(uri2);
    }

    public static ArgumentChecker<URI> schemaURIChecker() {
        return SCHEMAURI_CHECKER;
    }

    public static void checkSchemaURI(URI uri2) {
        SCHEMAURI_CHECKER.check(uri2);
    }
}

