/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.jsonschema.core.util.AsJsonValueHolder;
import com.github.fge.jsonschema.core.util.SimpleValueHolder;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class ValueHolder<T>
implements MessageProvider {
    protected static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final String name;
    protected final T value;

    public static <V> ValueHolder<V> hold(V value2) {
        return new SimpleValueHolder<V>("value", value2);
    }

    public static <V> ValueHolder<V> hold(String name, V value2) {
        return new SimpleValueHolder<V>(name, value2);
    }

    public static <V extends AsJson> ValueHolder<V> hold(V value2) {
        return new AsJsonValueHolder<V>("value", value2);
    }

    public static <V extends AsJson> ValueHolder<V> hold(String name, V value2) {
        return new AsJsonValueHolder<V>(name, value2);
    }

    protected ValueHolder(String name, T value2) {
        this.name = name;
        this.value = value2;
    }

    protected abstract JsonNode valueAsJson();

    public final String getName() {
        return this.name;
    }

    public final T getValue() {
        return this.value;
    }

    @Override
    public final ProcessingMessage newMessage() {
        return new ProcessingMessage().put(this.name, this.valueAsJson());
    }
}

