/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.examples.Utils;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.github.fge.msgsimple.source.MapMessageSource;
import com.github.fge.msgsimple.source.MessageSource;
import java.io.IOException;
import java.util.UUID;

public final class Example8 {
    public static void main(String ... args2) throws IOException, ProcessingException {
        JsonNode customSchema = Utils.loadResource("/custom-fmt.json");
        JsonNode good = Utils.loadResource("/custom-fmt-good.json");
        JsonNode bad = Utils.loadResource("/custom-fmt-bad.json");
        Library library = DraftV4Library.get().thaw().addFormatAttribute("uuid", UUIDFormatAttribute.getInstance()).freeze();
        String key2 = "invalidUUID";
        String value2 = "input is not a valid UUID";
        MessageSource source2 = MapMessageSource.newBuilder().put("invalidUUID", "input is not a valid UUID").build();
        MessageBundle bundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class).thaw().appendSource(source2).freeze();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://my.site/myschema#", library).setValidationMessages(bundle).freeze();
        JsonSchemaFactory factory2 = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        JsonSchema schema = factory2.getJsonSchema(customSchema);
        ProcessingReport report = schema.validate(good);
        System.out.println(report);
        report = schema.validate(bad);
        System.out.println(report);
    }

    private static final class UUIDFormatAttribute
    extends AbstractFormatAttribute {
        private static final FormatAttribute INSTANCE = new UUIDFormatAttribute();

        private UUIDFormatAttribute() {
            super("uuid", NodeType.STRING, new NodeType[0]);
        }

        public static FormatAttribute getInstance() {
            return INSTANCE;
        }

        @Override
        public void validate(ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
            String value2 = data2.getInstance().getNode().textValue();
            try {
                UUID.fromString(value2);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.newMsg(data2, bundle, "invalidUUID").put("input", value2));
            }
        }
    }
}

