/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.extra;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.uritemplate.URITemplate;
import com.github.fge.uritemplate.URITemplateParseException;

public final class URITemplateFormatAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new URITemplateFormatAttribute();

    private URITemplateFormatAttribute() {
        super("uri-template", NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        String value2 = data2.getInstance().getNode().textValue();
        try {
            new URITemplate(value2);
        }
        catch (URITemplateParseException ignored) {
            report.error(this.newMsg(data2, bundle, "err.format.uriTemplate.invalid").putArgument("value", value2));
        }
    }
}

