/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;

public final class DraftV3DependenciesDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new DraftV3DependenciesDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private DraftV3DependenciesDigester() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ObjectNode propertyDeps = FACTORY.objectNode();
        ret.set("propertyDeps", propertyDeps);
        ArrayNode schemaDeps = FACTORY.arrayNode();
        ret.set("schemaDeps", schemaDeps);
        ArrayList<String> list = Lists.newArrayList();
        Map<String, JsonNode> map2 = JacksonUtils.asMap(schema.get(this.keyword));
        for (Map.Entry<String, JsonNode> entry : map2.entrySet()) {
            String key2 = entry.getKey();
            JsonNode value2 = entry.getValue();
            NodeType type2 = NodeType.getNodeType(value2);
            switch (type2) {
                case OBJECT: {
                    list.add(key2);
                    break;
                }
                case ARRAY: {
                    JsonNode node = DraftV3DependenciesDigester.sortedSet(value2);
                    if (node.size() == 0) break;
                    propertyDeps.set(key2, node);
                    break;
                }
                case STRING: {
                    propertyDeps.set(key2, FACTORY.arrayNode().add(value2.textValue()));
                    break;
                }
            }
        }
        for (String s2 : Ordering.natural().sortedCopy(list)) {
            schemaDeps.add(s2);
        }
        return ret;
    }

    private static JsonNode sortedSet(JsonNode node) {
        TreeSet<JsonNode> set2 = Sets.newTreeSet(new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                return o1.textValue().compareTo(o2.textValue());
            }
        });
        set2.addAll(Sets.newHashSet(node));
        ArrayNode ret = FACTORY.arrayNode();
        ret.addAll(set2);
        return ret;
    }
}

