/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public final class DraftV4DependenciesDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new DraftV4DependenciesDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private DraftV4DependenciesDigester() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ObjectNode propertyDeps = FACTORY.objectNode();
        ret.set("propertyDeps", propertyDeps);
        ArrayNode schemaDeps = FACTORY.arrayNode();
        ret.set("schemaDeps", schemaDeps);
        ArrayList<String> list = Lists.newArrayList();
        Map<String, JsonNode> map2 = JacksonUtils.asMap(schema.get(this.keyword));
        for (Map.Entry<String, JsonNode> entry : map2.entrySet()) {
            String key2 = entry.getKey();
            JsonNode value2 = entry.getValue();
            if (value2.isObject()) {
                list.add(key2);
                continue;
            }
            propertyDeps.set(key2, DraftV4DependenciesDigester.sortedSet(value2));
        }
        for (String s2 : Ordering.natural().sortedCopy(list)) {
            schemaDeps.add(s2);
        }
        return ret;
    }

    private static JsonNode sortedSet(JsonNode node) {
        ArrayList<JsonNode> list = Lists.newArrayList(node);
        Collections.sort(list, new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                return o1.textValue().compareTo(o2.textValue());
            }
        });
        ArrayNode ret = FACTORY.arrayNode();
        ret.addAll(list);
        return ret;
    }
}

