/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import java.util.EnumSet;

public final class DraftV3TypeKeywordDigester
extends AbstractDigester {
    private static final String ANY = "any";

    public DraftV3TypeKeywordDigester(String keyword) {
        super(keyword, NodeType.ARRAY, NodeType.values());
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ArrayNode simpleTypes = FACTORY.arrayNode();
        ret.set(this.keyword, simpleTypes);
        ArrayNode schemas = FACTORY.arrayNode();
        ret.set("schemas", schemas);
        JsonNode node = schema.get(this.keyword);
        EnumSet<NodeType> set2 = EnumSet.noneOf(NodeType.class);
        if (node.isTextual()) {
            DraftV3TypeKeywordDigester.putType(set2, node.textValue());
        } else {
            int size2 = node.size();
            for (int index = 0; index < size2; ++index) {
                JsonNode element = node.get(index);
                if (element.isTextual()) {
                    DraftV3TypeKeywordDigester.putType(set2, element.textValue());
                    continue;
                }
                schemas.add(index);
            }
        }
        if (EnumSet.complementOf(set2).isEmpty()) {
            schemas.removeAll();
        }
        for (NodeType type2 : set2) {
            simpleTypes.add(type2.toString());
        }
        return ret;
    }

    private static void putType(EnumSet<NodeType> types, String s2) {
        if (ANY.equals(s2)) {
            types.addAll(EnumSet.allOf(NodeType.class));
            return;
        }
        NodeType type2 = NodeType.fromName(s2);
        types.add(type2);
        if (type2 == NodeType.NUMBER) {
            types.add(NodeType.INTEGER);
        }
    }
}

