/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class AdditionalItemsValidator
extends AbstractKeywordValidator {
    private final boolean additionalOK;
    private final int itemsSize;

    public AdditionalItemsValidator(JsonNode digest) {
        super("additionalItems");
        this.additionalOK = digest.get(this.keyword).booleanValue();
        this.itemsSize = digest.get("itemsSize").intValue();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        if (this.additionalOK) {
            return;
        }
        int size2 = data2.getInstance().getNode().size();
        if (size2 > this.itemsSize) {
            report.error(this.newMsg(data2, bundle, "err.common.additionalItems.notAllowed").putArgument("allowed", this.itemsSize).putArgument("found", size2));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + (this.additionalOK ? "allowed" : this.itemsSize + " max");
    }
}

