/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.helpers.PositiveIntegerValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class MinLengthValidator
extends PositiveIntegerValidator {
    public MinLengthValidator(JsonNode digested) {
        super("minLength", digested);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        String value2 = data2.getInstance().getNode().textValue();
        int size2 = value2.codePointCount(0, value2.length());
        if (size2 < this.intValue) {
            report.error(this.newMsg(data2, bundle, "err.common.minLength.tooShort").putArgument("value", value2).putArgument("found", size2).putArgument(this.keyword, this.intValue));
        }
    }
}

