/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.helpers.NumericValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.math.BigDecimal;

public final class MinimumValidator
extends NumericValidator {
    private final boolean exclusive;

    public MinimumValidator(JsonNode digest) {
        super("minimum", digest);
        this.exclusive = digest.path("exclusive").asBoolean(false);
    }

    @Override
    protected void validateLong(ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        long longValue;
        JsonNode instance = data2.getInstance().getNode();
        long instanceValue = instance.longValue();
        if (instanceValue > (longValue = this.number.longValue())) {
            return;
        }
        if (instanceValue < longValue) {
            report.error(this.newMsg(data2, bundle, "err.common.minimum.tooSmall").putArgument(this.keyword, this.number).putArgument("found", instance));
            return;
        }
        if (!this.exclusive) {
            return;
        }
        report.error(this.newMsg(data2, bundle, "err.common.minimum.notExclusive").putArgument(this.keyword, this.number).put("exclusiveMinimum", BooleanNode.TRUE));
    }

    @Override
    protected void validateDecimal(ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        BigDecimal decimalValue;
        JsonNode instance = data2.getInstance().getNode();
        BigDecimal instanceValue = instance.decimalValue();
        int cmp = instanceValue.compareTo(decimalValue = this.number.decimalValue());
        if (cmp > 0) {
            return;
        }
        if (cmp < 0) {
            report.error(this.newMsg(data2, bundle, "err.common.minimum.tooSmall").putArgument(this.keyword, this.number).putArgument("found", instance));
            return;
        }
        if (!this.exclusive) {
            return;
        }
        report.error(this.newMsg(data2, bundle, "err.common.minimum.notExclusive").putArgument(this.keyword, this.number).put("exclusiveMinimum", BooleanNode.TRUE));
    }
}

