/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;

public final class PropertiesValidator
extends AbstractKeywordValidator {
    private final Set<String> required;

    public PropertiesValidator(JsonNode digest) {
        super("properties");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode element : digest.get("required")) {
            builder.add(element.textValue());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        LinkedHashSet<String> set2 = Sets.newLinkedHashSet(this.required);
        set2.removeAll(Sets.newHashSet(data2.getInstance().getNode().fieldNames()));
        if (!set2.isEmpty()) {
            report.error(this.newMsg(data2, bundle, "err.common.object.missingMembers").put("required", this.required).putArgument("missing", PropertiesValidator.toArrayNode(set2)));
        }
    }

    @Override
    public String toString() {
        return "required: " + this.required.size() + " properties";
    }
}

