/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.helpers.SchemaArrayValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class AllOfValidator
extends SchemaArrayValidator {
    public AllOfValidator(JsonNode digest) {
        super("allOf");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        SchemaTree tree = data2.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        JsonNode schemas = tree.getNode().get(this.keyword);
        int size2 = schemas.size();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        for (int index = 0; index < size2; ++index) {
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of(this.keyword, index));
            FullData newData = data2.withSchema(tree.setPointer(ptr));
            processor.process(subReport, newData);
            fullReport.set(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess != size2) {
            report.error(this.newMsg(data2, bundle, "err.draftv4.allOf.fail").putArgument("matched", nrSuccess).putArgument("nrSchemas", size2).put("reports", fullReport));
        }
    }
}

