/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class NotValidator
extends AbstractKeywordValidator {
    private static final JsonPointer PTR = JsonPointer.of("not", new Object[0]);

    public NotValidator(JsonNode digest) {
        super("not");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        SchemaTree tree = data2.getSchema();
        ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
        processor.process(subReport, data2.withSchema(tree.append(PTR)));
        if (subReport.isSuccess()) {
            report.error(this.newMsg(data2, bundle, "err.draftv4.not.fail"));
        }
    }

    @Override
    public String toString() {
        return "must not match subschema";
    }
}

