/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public abstract class NumericValidator
extends AbstractKeywordValidator {
    protected final JsonNode number;
    private final boolean isLong;

    protected NumericValidator(String keyword, JsonNode digest) {
        super(keyword);
        this.number = digest.get(keyword);
        this.isLong = digest.get("valueIsLong").booleanValue();
    }

    @Override
    public final void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data2) throws ProcessingException {
        JsonNode instance = data2.getInstance().getNode();
        if (NumericValidator.valueIsLong(instance) && this.isLong) {
            this.validateLong(report, bundle, data2);
        } else {
            this.validateDecimal(report, bundle, data2);
        }
    }

    protected abstract void validateLong(ProcessingReport var1, MessageBundle var2, FullData var3) throws ProcessingException;

    protected abstract void validateDecimal(ProcessingReport var1, MessageBundle var2, FullData var3) throws ProcessingException;

    @Override
    public final String toString() {
        return this.keyword + ": " + this.number;
    }

    private static boolean valueIsLong(JsonNode node) {
        return NodeType.getNodeType(node) == NodeType.INTEGER && node.canConvertToLong();
    }
}

