/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library.validator;

import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.jsonschema.core.util.DictionaryBuilder;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import com.github.fge.jsonschema.keyword.validator.ReflectionKeywordValidatorFactory;
import com.github.fge.jsonschema.keyword.validator.common.AdditionalItemsValidator;
import com.github.fge.jsonschema.keyword.validator.common.AdditionalPropertiesValidator;
import com.github.fge.jsonschema.keyword.validator.common.EnumValidator;
import com.github.fge.jsonschema.keyword.validator.common.MaxItemsValidator;
import com.github.fge.jsonschema.keyword.validator.common.MaxLengthValidator;
import com.github.fge.jsonschema.keyword.validator.common.MaximumValidator;
import com.github.fge.jsonschema.keyword.validator.common.MinItemsValidator;
import com.github.fge.jsonschema.keyword.validator.common.MinLengthValidator;
import com.github.fge.jsonschema.keyword.validator.common.MinimumValidator;
import com.github.fge.jsonschema.keyword.validator.common.PatternValidator;
import com.github.fge.jsonschema.keyword.validator.common.UniqueItemsValidator;

public final class CommonValidatorDictionary {
    private static final Dictionary<KeywordValidatorFactory> DICTIONARY;

    private CommonValidatorDictionary() {
    }

    public static Dictionary<KeywordValidatorFactory> get() {
        return DICTIONARY;
    }

    private static KeywordValidatorFactory factory(String name, Class<? extends KeywordValidator> c2) {
        return new ReflectionKeywordValidatorFactory(name, c2);
    }

    static {
        DictionaryBuilder<KeywordValidatorFactory> builder = Dictionary.newBuilder();
        String keyword = "additionalItems";
        Class c2 = AdditionalItemsValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "minItems";
        c2 = MinItemsValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "maxItems";
        c2 = MaxItemsValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "uniqueItems";
        c2 = UniqueItemsValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "minimum";
        c2 = MinimumValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "maximum";
        c2 = MaximumValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "additionalProperties";
        c2 = AdditionalPropertiesValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "minLength";
        c2 = MinLengthValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "maxLength";
        c2 = MaxLengthValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "pattern";
        c2 = PatternValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        keyword = "enum";
        c2 = EnumValidator.class;
        builder.addEntry(keyword, CommonValidatorDictionary.factory(keyword, c2));
        DICTIONARY = builder.freeze();
    }
}

