/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library.validator;

import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.jsonschema.core.util.DictionaryBuilder;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import com.github.fge.jsonschema.keyword.validator.ReflectionKeywordValidatorFactory;
import com.github.fge.jsonschema.keyword.validator.common.DependenciesValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.AllOfValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.AnyOfValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.DraftV4TypeValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MaxPropertiesValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MinPropertiesValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.MultipleOfValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.NotValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.OneOfValidator;
import com.github.fge.jsonschema.keyword.validator.draftv4.RequiredKeywordValidator;
import com.github.fge.jsonschema.library.validator.CommonValidatorDictionary;

public final class DraftV4ValidatorDictionary {
    private static final Dictionary<KeywordValidatorFactory> DICTIONARY;

    private DraftV4ValidatorDictionary() {
    }

    public static Dictionary<KeywordValidatorFactory> get() {
        return DICTIONARY;
    }

    private static KeywordValidatorFactory factory(String name, Class<? extends KeywordValidator> c2) {
        return new ReflectionKeywordValidatorFactory(name, c2);
    }

    static {
        DictionaryBuilder<KeywordValidatorFactory> builder = Dictionary.newBuilder();
        builder.addAll(CommonValidatorDictionary.get());
        String keyword = "multipleOf";
        Class c2 = MultipleOfValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "minProperties";
        c2 = MinPropertiesValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "maxProperties";
        c2 = MaxPropertiesValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "required";
        c2 = RequiredKeywordValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "dependencies";
        c2 = DependenciesValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "anyOf";
        c2 = AnyOfValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "allOf";
        c2 = AllOfValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "oneOf";
        c2 = OneOfValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "not";
        c2 = NotValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        keyword = "type";
        c2 = DraftV4TypeValidator.class;
        builder.addEntry(keyword, DraftV4ValidatorDictionary.factory(keyword, c2));
        DICTIONARY = builder.freeze();
    }
}

