/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.ProcessingResult;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.report.ReportProvider;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.tree.SimpleJsonTree;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import javax.annotation.concurrent.Immutable;

@Immutable
final class JsonSchemaImpl
implements JsonSchema {
    private final ValidationProcessor processor;
    private final SchemaTree schema;
    private final ReportProvider reportProvider;

    JsonSchemaImpl(ValidationProcessor processor, SchemaTree schema, ReportProvider reportProvider) {
        this.processor = processor;
        this.schema = schema;
        this.reportProvider = reportProvider;
    }

    private ProcessingReport doValidate(JsonNode node, boolean deepCheck) throws ProcessingException {
        FullData data2 = new FullData(this.schema, new SimpleJsonTree(node), deepCheck);
        ProcessingReport report = this.reportProvider.newReport();
        ProcessingResult<FullData> result2 = ProcessingResult.of(this.processor, report, data2);
        return result2.getReport();
    }

    private ProcessingReport doValidateUnchecked(JsonNode node, boolean deepCheck) {
        FullData data2 = new FullData(this.schema, new SimpleJsonTree(node), deepCheck);
        ProcessingReport report = this.reportProvider.newReport();
        ProcessingResult<FullData> result2 = ProcessingResult.uncheckedResult(this.processor, report, data2);
        return result2.getReport();
    }

    @Override
    public ProcessingReport validate(JsonNode instance, boolean deepCheck) throws ProcessingException {
        return this.doValidate(instance, deepCheck);
    }

    @Override
    public ProcessingReport validate(JsonNode instance) throws ProcessingException {
        return this.validate(instance, false);
    }

    @Override
    public ProcessingReport validateUnchecked(JsonNode instance, boolean deepCheck) {
        return this.doValidateUnchecked(instance, deepCheck);
    }

    @Override
    public ProcessingReport validateUnchecked(JsonNode instance) {
        return this.doValidateUnchecked(instance, false);
    }

    @Override
    public boolean validInstance(JsonNode instance) throws ProcessingException {
        return this.doValidate(instance, false).isSuccess();
    }

    @Override
    public boolean validInstanceUnchecked(JsonNode instance) {
        return this.doValidateUnchecked(instance, false).isSuccess();
    }
}

