/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.digest;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.Dictionary;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.SchemaDigest;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;

public final class SchemaDigester
implements Processor<SchemaContext, SchemaDigest> {
    private final ListMultimap<NodeType, String> typeMap = ArrayListMultimap.create();
    private final Map<String, Digester> digesterMap = Maps.newHashMap();

    public SchemaDigester(Library library) {
        this(library.getDigesters());
    }

    public SchemaDigester(Dictionary<Digester> dict) {
        Map<String, Digester> map2 = dict.entries();
        for (Map.Entry<String, Digester> entry : map2.entrySet()) {
            String keyword = entry.getKey();
            Digester digester = entry.getValue();
            this.digesterMap.put(keyword, digester);
            for (NodeType type2 : digester.supportedTypes()) {
                this.typeMap.put(type2, keyword);
            }
        }
    }

    @Override
    public SchemaDigest process(ProcessingReport report, SchemaContext input) throws ProcessingException {
        JsonNode schema = input.getSchema().getNode();
        NodeType type2 = input.getInstanceType();
        HashMap<String, JsonNode> map2 = Maps.newHashMap(this.buildDigests(schema));
        map2.keySet().retainAll(this.typeMap.get((Object)type2));
        return new SchemaDigest(input, map2);
    }

    private Map<String, JsonNode> buildDigests(JsonNode schema) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap<String, Digester> map2 = Maps.newHashMap(this.digesterMap);
        map2.keySet().retainAll(Sets.newHashSet(schema.fieldNames()));
        for (Map.Entry entry : map2.entrySet()) {
            builder.put(entry.getKey(), ((Digester)entry.getValue()).digest(schema));
        }
        return builder.build();
    }

    public String toString() {
        return "schema digester";
    }
}

