/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;

public final class ObjectSchemaDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new ObjectSchemaDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private ObjectSchemaDigester() {
        super("", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("hasAdditional", schema.path("additionalProperties").isObject());
        ArrayNode node = FACTORY.arrayNode();
        ret.set("properties", node);
        HashSet<String> set2 = Sets.newHashSet(schema.path("properties").fieldNames());
        for (String field : Ordering.natural().sortedCopy(set2)) {
            node.add(field);
        }
        node = FACTORY.arrayNode();
        ret.set("patternProperties", node);
        set2 = Sets.newHashSet(schema.path("patternProperties").fieldNames());
        for (String field : Ordering.natural().sortedCopy(set2)) {
            node.add(field);
        }
        return ret;
    }
}

