/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.bundle;

import com.github.fge.Frozen;
import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.bundle.MessageBundleBuilder;
import com.github.fge.msgsimple.locale.LocaleUtils;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.provider.StaticMessageSourceProvider;
import com.github.fge.msgsimple.source.MessageSource;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MessageBundle
implements Frozen<MessageBundleBuilder> {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    final List<MessageSourceProvider> providers = new ArrayList<MessageSourceProvider>();

    public static MessageBundleBuilder newBuilder() {
        return new MessageBundleBuilder();
    }

    public static MessageBundle withSingleSource(MessageSource source2) {
        MessageSourceProvider provider2 = StaticMessageSourceProvider.withSingleSource(source2);
        return MessageBundle.newBuilder().appendProvider(provider2).freeze();
    }

    MessageBundle(MessageBundleBuilder builder) {
        this.providers.addAll(builder.providers);
    }

    public String getMessage(Locale locale, String key2) {
        BUNDLE.checkNotNull(key2, "query.nullKey");
        BUNDLE.checkNotNull(locale, "query.nullLocale");
        for (Locale l : LocaleUtils.getApplicable(locale)) {
            for (MessageSourceProvider provider2 : this.providers) {
                String ret;
                MessageSource source2 = provider2.getMessageSource(l);
                if (source2 == null || (ret = source2.getKey(key2)) == null) continue;
                return ret;
            }
        }
        return key2;
    }

    public String getMessage(String key2) {
        return this.getMessage(Locale.getDefault(), key2);
    }

    public String printf(Locale locale, String key2, Object ... params) {
        String format2 = this.getMessage(locale, key2);
        try {
            return String.format(locale, format2, params);
        }
        catch (IllegalFormatException ignored) {
            return format2;
        }
    }

    public String printf(String key2, Object ... params) {
        return this.printf(Locale.getDefault(), key2, params);
    }

    public String format(Locale locale, String key2, Object ... params) {
        String pattern2 = this.getMessage(locale, key2);
        try {
            return new MessageFormat(pattern2, locale).format(params, new StringBuffer(pattern2.length()), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException ignored) {
            return pattern2;
        }
    }

    public String format(String key2, Object ... params) {
        return this.format(Locale.getDefault(), key2, params);
    }

    public <T> T checkNotNull(T reference, Locale locale, String key2) {
        if (reference == null) {
            throw new NullPointerException(this.getMessage(locale, key2));
        }
        return reference;
    }

    public <T> T checkNotNull(T reference, String key2) {
        return this.checkNotNull(reference, Locale.getDefault(), key2);
    }

    public void checkArgument(boolean condition, Locale locale, String key2) {
        if (!condition) {
            throw new IllegalArgumentException(this.getMessage(locale, key2));
        }
    }

    public void checkArgument(boolean condition, String key2) {
        this.checkArgument(condition, Locale.getDefault(), key2);
    }

    public <T> T checkNotNullPrintf(T reference, Locale locale, String key2, Object ... params) {
        if (reference == null) {
            throw new NullPointerException(this.printf(locale, key2, params));
        }
        return reference;
    }

    public <T> T checkNotNullPrintf(T reference, String key2, Object ... params) {
        return this.checkNotNullPrintf(reference, Locale.getDefault(), key2, params);
    }

    public void checkArgumentPrintf(boolean condition, Locale locale, String key2, Object ... params) {
        if (!condition) {
            throw new IllegalArgumentException(this.printf(locale, key2, params));
        }
    }

    public void checkArgumentPrintf(boolean condition, String key2, Object ... params) {
        this.checkArgumentPrintf(condition, Locale.getDefault(), key2, params);
    }

    public <T> T checkNotNullFormat(T reference, Locale locale, String key2, Object ... params) {
        if (reference == null) {
            throw new NullPointerException(this.format(locale, key2, params));
        }
        return reference;
    }

    public <T> T checkNotNullFormat(T reference, String key2, Object ... params) {
        return this.checkNotNullFormat(reference, Locale.getDefault(), key2, params);
    }

    public void checkArgumentFormat(boolean condition, Locale locale, String key2, Object ... params) {
        if (!condition) {
            throw new IllegalArgumentException(this.format(locale, key2, params));
        }
    }

    public void checkArgumentFormat(boolean condition, String key2, Object ... params) {
        this.checkArgumentFormat(condition, Locale.getDefault(), key2, params);
    }

    @Override
    public MessageBundleBuilder thaw() {
        return new MessageBundleBuilder(this);
    }
}

