/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.bundle;

import com.github.fge.Thawed;
import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.provider.StaticMessageSourceProvider;
import com.github.fge.msgsimple.source.MessageSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class MessageBundleBuilder
implements Thawed<MessageBundle> {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    final List<MessageSourceProvider> providers = new ArrayList<MessageSourceProvider>();

    MessageBundleBuilder() {
    }

    MessageBundleBuilder(MessageBundle bundle) {
        this.providers.addAll(bundle.providers);
    }

    public MessageBundleBuilder appendProvider(MessageSourceProvider provider2) {
        BUNDLE.checkNotNull(provider2, "cfg.nullProvider");
        this.providers.add(provider2);
        return this;
    }

    public MessageBundleBuilder prependProvider(MessageSourceProvider provider2) {
        BUNDLE.checkNotNull(provider2, "cfg.nullProvider");
        this.providers.add(0, provider2);
        return this;
    }

    public MessageBundleBuilder appendSource(MessageSource source2) {
        MessageSourceProvider provider2 = StaticMessageSourceProvider.withSingleSource(source2);
        this.providers.add(provider2);
        return this;
    }

    public MessageBundleBuilder prependSource(MessageSource source2) {
        MessageSourceProvider provider2 = StaticMessageSourceProvider.withSingleSource(source2);
        this.providers.add(0, provider2);
        return this;
    }

    public MessageBundleBuilder appendSource(Locale locale, MessageSource source2) {
        MessageSourceProvider provider2 = StaticMessageSourceProvider.withSingleSource(locale, source2);
        this.providers.add(provider2);
        return this;
    }

    public MessageBundleBuilder prependSource(Locale locale, MessageSource source2) {
        MessageSourceProvider provider2 = StaticMessageSourceProvider.withSingleSource(locale, source2);
        this.providers.add(0, provider2);
        return this;
    }

    public MessageBundleBuilder appendBundle(MessageBundle bundle) {
        BUNDLE.checkNotNull(bundle, "cfg.nullBundle");
        this.providers.addAll(bundle.providers);
        return this;
    }

    public MessageBundleBuilder prependBundle(MessageBundle bundle) {
        BUNDLE.checkNotNull(bundle, "cfg.nullBundle");
        ArrayList<MessageSourceProvider> list = new ArrayList<MessageSourceProvider>();
        list.addAll(bundle.providers);
        list.addAll(this.providers);
        this.providers.clear();
        this.providers.addAll(list);
        return this;
    }

    @Override
    public MessageBundle freeze() {
        return new MessageBundle(this);
    }
}

