/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.source;

import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.source.MessageSource;
import java.util.HashMap;
import java.util.Map;

public final class MapMessageSource
implements MessageSource {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private final Map<String, String> messages;

    private MapMessageSource(Builder builder) {
        this.messages = new HashMap<String, String>(builder.messages);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getKey(String key2) {
        return this.messages.get(key2);
    }

    public static final class Builder {
        private final Map<String, String> messages = new HashMap<String, String>();

        private Builder() {
        }

        public Builder put(String key2, String message) {
            BUNDLE.checkNotNull(key2, "cfg.map.nullKey");
            BUNDLE.checkNotNull(message, "cfg.map.nullValue");
            this.messages.put(key2, message);
            return this;
        }

        public Builder putAll(Map<String, String> map2) {
            BUNDLE.checkNotNull(map2, "cfg.nullMap");
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public MessageSource build() {
            return new MapMessageSource(this);
        }
    }
}

