/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.source;

import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.source.MessageSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class PropertiesMessageSource
implements MessageSource {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Map<String, String> messages = new HashMap<String, String>();

    public static MessageSource fromResource(String resourcePath) throws IOException {
        return PropertiesMessageSource.fromResource(resourcePath, UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageSource fromResource(String resourcePath, Charset charset) throws IOException {
        BUNDLE.checkNotNull(resourcePath, "cfg.nullResourcePath");
        URL url2 = PropertiesMessageSource.class.getResource(resourcePath);
        if (url2 == null) {
            throw new IOException(BUNDLE.printf("properties.resource.notFound", resourcePath));
        }
        InputStream in = url2.openStream();
        try {
            MessageSource messageSource = PropertiesMessageSource.fromInputStream(in, charset);
            return messageSource;
        }
        finally {
            PropertiesMessageSource.closeQuietly(in);
        }
    }

    public static MessageSource fromFile(File file2) throws IOException {
        return PropertiesMessageSource.fromFile(file2, UTF8);
    }

    public static MessageSource fromPath(String path2) throws IOException {
        BUNDLE.checkNotNull(path2, "cfg.nullPath");
        return PropertiesMessageSource.fromFile(new File(path2), UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageSource fromFile(File file2, Charset charset) throws IOException {
        BUNDLE.checkNotNull(file2, "cfg.nullFile");
        FileInputStream in = new FileInputStream(file2);
        try {
            MessageSource messageSource = PropertiesMessageSource.fromInputStream(in, charset);
            return messageSource;
        }
        finally {
            PropertiesMessageSource.closeQuietly(in);
        }
    }

    public static MessageSource fromPath(String path2, Charset charset) throws IOException {
        BUNDLE.checkNotNull(path2, "cfg.nullPath");
        return PropertiesMessageSource.fromFile(new File(path2), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MessageSource fromInputStream(InputStream in, Charset charset) throws IOException {
        BUNDLE.checkNotNull(in, "cfg.nullInputStream");
        InputStreamReader reader2 = new InputStreamReader(in, charset);
        try {
            Properties properties = new Properties();
            properties.load(reader2);
            PropertiesMessageSource propertiesMessageSource = new PropertiesMessageSource(properties);
            return propertiesMessageSource;
        }
        finally {
            PropertiesMessageSource.closeQuietly(reader2);
        }
    }

    private PropertiesMessageSource(Properties properties) {
        for (String key2 : properties.stringPropertyNames()) {
            this.messages.put(key2, properties.getProperty(key2));
        }
    }

    @Override
    public String getKey(String key2) {
        return this.messages.get(key2);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

