/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.parse;

import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.github.fge.uritemplate.URITemplateMessageBundle;
import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.expression.TemplateLiteral;
import com.github.fge.uritemplate.expression.URITemplateExpression;
import com.github.fge.uritemplate.parse.CharMatchers;
import com.github.fge.uritemplate.parse.TemplateParser;
import java.nio.CharBuffer;

final class LiteralParser
implements TemplateParser {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(URITemplateMessageBundle.class);

    LiteralParser() {
    }

    @Override
    public URITemplateExpression parse(CharBuffer buffer) throws URITemplateParseException {
        char c2;
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining() && CharMatchers.LITERALS.matches(c2 = buffer.charAt(0))) {
            sb.append(buffer.get());
            if (!CharMatchers.PERCENT.matches(c2)) continue;
            LiteralParser.parsePercentEncoded(buffer, sb);
        }
        return new TemplateLiteral(sb.toString());
    }

    private static void parsePercentEncoded(CharBuffer buffer, StringBuilder sb) throws URITemplateParseException {
        if (buffer.remaining() < 2) {
            throw new URITemplateParseException(BUNDLE.getMessage("paser.percentShortRead"), buffer, true);
        }
        char first2 = buffer.get();
        if (!CharMatchers.HEXDIGIT.matches(first2)) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.percentIllegal"), buffer, true);
        }
        char second2 = buffer.get();
        if (!CharMatchers.HEXDIGIT.matches(second2)) {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.percentIllegal"), buffer, true);
        }
        sb.append(first2).append(second2);
    }
}

