/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.render;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.render.ValueRenderer;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class StringRenderer
extends ValueRenderer {
    public StringRenderer(ExpressionType type2) {
        super(type2);
    }

    @Override
    public List<String> render(VariableSpec varspec, VariableValue value2) throws URITemplateException {
        return ImmutableList.of(this.doRender(varspec, value2.getScalarValue()));
    }

    private String doRender(VariableSpec varspec, String value2) {
        int prefixLen;
        StringBuilder sb = new StringBuilder(value2.length());
        if (this.named) {
            sb.append(varspec.getName());
            if (value2.isEmpty()) {
                return sb.append(this.ifEmpty).toString();
            }
            sb.append('=');
        }
        if ((prefixLen = varspec.getPrefixLength()) == -1) {
            return sb.append(this.pctEncode(value2)).toString();
        }
        int len2 = value2.codePointCount(0, value2.length());
        return len2 <= prefixLen ? sb.append(this.pctEncode(value2)).toString() : sb.append(this.pctEncode(StringRenderer.nFirstChars(value2, prefixLen))).toString();
    }

    private static String nFirstChars(String s2, int n) {
        int realIndex = n;
        while (s2.codePointCount(0, realIndex) != n) {
            ++realIndex;
        }
        return s2.substring(0, realIndex);
    }
}

