/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.RedisServer;
import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.commands.RedisCommand;
import com.github.fppt.jedismock.commands.RedisCommandParser;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.EOFException;
import com.github.fppt.jedismock.exception.ParseErrorException;
import com.github.fppt.jedismock.server.RedisOperationExecutor;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.ServiceOptions;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.time.Clock;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedisClient
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClient.class);
    private final RedisServer server;
    private final Socket socket;
    private final AtomicBoolean running;
    private final RedisOperationExecutor executor;
    private final InputStream in;
    private final OutputStream out;
    private final Consumer<RedisClient> onClose;

    RedisClient(RedisServer server2, Socket socket, Consumer<RedisClient> onClose2) throws IOException {
        Objects.requireNonNull(server2);
        Objects.requireNonNull(socket);
        Objects.requireNonNull(onClose2);
        this.server = server2;
        OperationExecutorState state = new OperationExecutorState(this, server2.getRedisBases());
        this.executor = new RedisOperationExecutor(state);
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.running = new AtomicBoolean(true);
        this.onClose = onClose2;
    }

    @Override
    public void run() {
        while (this.running.get() && !this.socket.isClosed() && !Thread.interrupted()) {
            Optional<RedisCommand> command2 = this.nextCommand();
            if (!command2.isPresent()) continue;
            Slice response2 = this.executor.execCommand(command2.get());
            this.sendResponse(response2, command2.toString());
        }
        LOG.debug("Mock redis connection shut down.");
    }

    private Optional<RedisCommand> nextCommand() {
        try {
            return Optional.of(RedisCommandParser.parse(this.in));
        }
        catch (ParseErrorException e2) {
            return Optional.empty();
        }
        catch (EOFException e3) {
            this.close();
            return Optional.empty();
        }
    }

    public void sendResponse(Slice response2, String respondingTo) {
        try {
            if (!response2.equals(Response.SKIP)) {
                this.out.write(response2.data());
            }
        }
        catch (IOException e2) {
            LOG.error("unable to send [" + response2 + "] as response to [" + respondingTo + "]", e2);
        }
    }

    public void close() {
        this.running.set(false);
        Utils.closeQuietly(this.socket);
        Utils.closeQuietly(this.in);
        Utils.closeQuietly(this.out);
        this.onClose.accept(this);
    }

    public ServiceOptions options() {
        return this.server.options();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public Clock getClock() {
        return this.server.getClock();
    }

    public String getServerHost() {
        return this.server.getHost();
    }
}

