/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.RedisClient;
import com.github.fppt.jedismock.operations.CommandFactory;
import com.github.fppt.jedismock.server.ServiceOptions;
import com.github.fppt.jedismock.storage.RedisBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class RedisServer {
    private static final String NOT_RUNNING = "JedisMock is not running";
    private final int bindPort;
    private final InetAddress bindAddress;
    private final Map<Integer, RedisBase> redisBases;
    private volatile ExecutorService singleThreadPool;
    private volatile RedisServiceJob service;
    private volatile Clock clock = Clock.systemDefaultZone();
    private volatile ServiceOptions options = ServiceOptions.defaultOptions();
    private volatile Future<Void> serviceFinalization;

    public RedisServer() {
        this(0);
    }

    public RedisServer(int port2) {
        this(port2, null);
    }

    public RedisServer(int port2, InetAddress address) {
        this.bindPort = port2;
        this.bindAddress = address;
        this.redisBases = new HashMap<Integer, RedisBase>();
        CommandFactory.initialize();
    }

    public static RedisServer newRedisServer() {
        return new RedisServer();
    }

    public static RedisServer newRedisServer(int port2) {
        return new RedisServer(port2);
    }

    public static RedisServer newRedisServer(int port2, InetAddress address) {
        return new RedisServer(port2, address);
    }

    public RedisServer setOptions(ServiceOptions options2) {
        this.options = Objects.requireNonNull(options2);
        return this;
    }

    public RedisServer setClock(Clock clock) {
        this.clock = Objects.requireNonNull(clock);
        return this;
    }

    public RedisServer start() throws IOException {
        if (this.service != null) {
            throw new IllegalStateException();
        }
        this.service = new RedisServiceJob();
        this.singleThreadPool = Executors.newSingleThreadExecutor();
        this.serviceFinalization = this.singleThreadPool.submit(this.service);
        return this;
    }

    public void stop() throws IOException {
        Objects.requireNonNull(this.service, NOT_RUNNING);
        this.service.stop();
        this.service = null;
        try {
            this.serviceFinalization.get();
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException e2) {
            System.err.println("Jedis-mock interrupted while stopping");
            Thread.currentThread().interrupt();
        }
        finally {
            this.singleThreadPool.shutdownNow();
        }
    }

    public boolean isRunning() {
        return this.service != null;
    }

    public String getHost() {
        Objects.requireNonNull(this.service, NOT_RUNNING);
        return this.service.getServer().getInetAddress().getHostAddress();
    }

    public int getBindPort() {
        Objects.requireNonNull(this.service, NOT_RUNNING);
        return this.service.getServer().getLocalPort();
    }

    Map<Integer, RedisBase> getRedisBases() {
        return this.redisBases;
    }

    public ServiceOptions options() {
        return this.options;
    }

    public Clock getClock() {
        return this.clock;
    }

    private final class RedisServiceJob
    implements Callable<Void> {
        private final ServerSocket server;
        private final ExecutorService threadPool = Executors.newCachedThreadPool();
        private final List<RedisClient> clients = new CopyOnWriteArrayList<RedisClient>();

        public RedisServiceJob() throws IOException {
            Objects.requireNonNull(RedisServer.this.redisBases);
            Objects.requireNonNull(RedisServer.this.options);
            this.server = new ServerSocket(RedisServer.this.bindPort, 0, RedisServer.this.bindAddress);
        }

        @Override
        public Void call() throws IOException {
            while (!this.server.isClosed()) {
                Socket socket = this.server.accept();
                RedisClient rc2 = new RedisClient(RedisServer.this, socket, this.clients::remove);
                this.clients.add(rc2);
                this.threadPool.submit(rc2);
            }
            return null;
        }

        public ServerSocket getServer() {
            return this.server;
        }

        public void stop() throws IOException {
            this.clients.forEach(RedisClient::close);
            this.server.close();
            this.threadPool.shutdownNow();
        }
    }
}

