/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock;

import com.github.fppt.jedismock.exception.WrongValueTypeException;
import java.io.Closeable;

public class Utils {
    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static long convertToLong(String value2) {
        try {
            return Long.parseLong(value2);
        }
        catch (NumberFormatException e2) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public static byte convertToByte(String value2) {
        try {
            byte bit = Byte.parseByte(value2);
            if (bit != 0 && bit != 1) {
                throw new NumberFormatException();
            }
            return bit;
        }
        catch (NumberFormatException e2) {
            throw new WrongValueTypeException("ERR bit is not an integer or out of range");
        }
    }

    public static int convertToNonNegativeInteger(String value2) {
        try {
            int pos = Integer.parseInt(value2);
            if (pos < 0) {
                throw new NumberFormatException("Int less than 0");
            }
            return pos;
        }
        catch (NumberFormatException e2) {
            throw new WrongValueTypeException("ERR bit offset is not an integer or out of range");
        }
    }

    public static int convertToInteger(String value2) {
        try {
            return Integer.parseInt(value2);
        }
        catch (NumberFormatException e2) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public static double convertToDouble(String value2) {
        try {
            return Double.parseDouble(value2);
        }
        catch (NumberFormatException e2) {
            throw new WrongValueTypeException("ERR bit offset is not a double or out of range");
        }
    }

    public static String createRegexFromGlob(String glob) {
        StringBuilder out2 = new StringBuilder("^");
        block7: for (int i2 = 0; i2 < glob.length(); ++i2) {
            char c2 = glob.charAt(i2);
            switch (c2) {
                case '*': {
                    out2.append(".*");
                    continue block7;
                }
                case '?': {
                    out2.append('.');
                    continue block7;
                }
                case '.': {
                    out2.append("\\.");
                    continue block7;
                }
                case '\\': {
                    out2.append("\\\\");
                    continue block7;
                }
                case '{': {
                    out2.append("\\{");
                    continue block7;
                }
                default: {
                    out2.append(c2);
                }
            }
        }
        out2.append('$');
        return out2.toString();
    }

    public static long toNanoTimeout(String value2) {
        return (long)(Utils.convertToDouble(value2) * 1.0E9);
    }
}

