/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.commands;

import com.github.fppt.jedismock.commands.RedisCommand;
import com.github.fppt.jedismock.exception.ParseErrorException;
import com.github.fppt.jedismock.server.SliceParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;

public class RedisCommandParser {
    public static RedisCommand parse(String stringInput) throws ParseErrorException {
        Objects.requireNonNull(stringInput);
        return RedisCommandParser.parse(new ByteArrayInputStream(stringInput.getBytes()));
    }

    public static RedisCommand parse(InputStream messageInput) throws ParseErrorException {
        Objects.requireNonNull(messageInput);
        long count2 = SliceParser.consumeCount(messageInput);
        if (count2 == 0L) {
            throw new ParseErrorException();
        }
        RedisCommand command2 = RedisCommand.create();
        for (long i2 = 0L; i2 < count2; ++i2) {
            command2.parameters().add(SliceParser.consumeParameter(messageInput));
        }
        return command2;
    }
}

