/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.StringCompatible;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import java.util.BitSet;

public class RMBitMap
extends StringCompatible {
    private final BitSet bitSet;
    private int size;

    public RMBitMap() {
        this.size = 0;
        this.bitSet = new BitSet();
    }

    public RMBitMap(byte[] data2) {
        this.size = data2.length;
        byte[] reversed = new byte[data2.length];
        for (int i2 = 0; i2 < data2.length; ++i2) {
            reversed[i2] = RMBitMap.reverseBits(data2[i2]);
        }
        this.bitSet = BitSet.valueOf(reversed);
    }

    public void setBit(byte bit, int pos) {
        int newSize = (pos + 7) / 8;
        if (this.size < newSize) {
            this.size = newSize;
        }
        this.bitSet.set(pos, bit == 1);
    }

    public boolean getBit(int pos) {
        return this.bitSet.get(pos);
    }

    @Override
    public void raiseTypeCastException() {
        throw new WrongValueTypeException("WRONGTYPE RMBitMap value is used in the wrong place");
    }

    @Override
    public final Slice getAsSlice() {
        return Slice.create(this.toByteArray());
    }

    private byte[] toByteArray() {
        long[] longs = this.bitSet.toLongArray();
        byte[] bytes = new byte[this.size];
        int byteIndex = 0;
        for (long value2 : longs) {
            for (int i2 = 0; i2 < 8 && byteIndex < this.size; ++i2) {
                bytes[byteIndex++] = RMBitMap.reverseBits((byte)(value2 & 0xFFL));
                value2 >>>= 8;
            }
        }
        return bytes;
    }

    private static byte reverseBits(byte b2) {
        int buf = b2 & 0xFF;
        buf = (buf & 0xF0) >>> 4 | (buf & 0xF) << 4;
        buf = (buf & 0xCC) >>> 2 | (buf & 0x33) << 2;
        buf = (buf & 0xAA) >>> 1 | (buf & 0x55) << 1;
        return (byte)buf;
    }
}

