/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.StringCompatible;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RMHyperLogLog
extends StringCompatible
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient HashSet<Slice> storedData = new HashSet();

    public Set<Slice> getStoredData() {
        return this.storedData;
    }

    public int size() {
        return this.storedData.size();
    }

    public void addAll(Collection<Slice> data2) {
        this.storedData.addAll(data2);
    }

    @Override
    public void raiseTypeCastException() {
        throw new WrongValueTypeException("WRONGTYPE HyperLogLog is used in the wrong place");
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.storedData.size());
        for (Slice storedDatum : this.storedData) {
            s2.writeInt(storedDatum.data().length);
            for (byte datum : storedDatum.data()) {
                s2.writeByte(datum);
            }
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        this.storedData = new HashSet();
        s2.defaultReadObject();
        int count2 = s2.readInt();
        for (int i2 = 0; i2 < count2; ++i2) {
            int len2 = s2.readInt();
            byte[] buf = new byte[len2];
            for (int j2 = 0; j2 < len2; ++j2) {
                buf[j2] = s2.readByte();
            }
            this.storedData.add(Slice.create(buf));
        }
    }

    @Override
    public final Slice getAsSlice() {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream2 = new ObjectOutputStream(byteOutputStream);
            outputStream2.writeObject(this);
            return Slice.create(byteOutputStream.toByteArray());
        }
        catch (IOException exp2) {
            throw new IllegalStateException(exp2);
        }
    }
}

