/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.datastructures.ZSetEntryBound;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public class RMZSet
implements RMDataStructure {
    private final Map<Slice, Double> scores = new HashMap<Slice, Double>();
    private final NavigableSet<ZSetEntry> entries = new TreeSet<ZSetEntry>();

    public Double put(Slice value2, double score) {
        Double previous = this.scores.put(value2, score);
        if (previous != null) {
            this.entries.remove(new ZSetEntry(previous, value2));
        }
        this.entries.add(new ZSetEntry(score, value2));
        return previous;
    }

    public Double getScore(Slice value2) {
        return this.scores.get(value2);
    }

    public boolean hasMember(Slice member) {
        return this.scores.containsKey(member);
    }

    public boolean remove(Slice value2) {
        Double previous = this.scores.remove(value2);
        if (previous == null) {
            return false;
        }
        this.entries.remove(new ZSetEntry(previous, value2));
        return true;
    }

    public int size() {
        return this.scores.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public NavigableSet<ZSetEntry> subset(ZSetEntryBound start2, ZSetEntryBound end2) {
        if (start2.getBound().compareTo(end2.getBound()) > 0) {
            return Collections.emptyNavigableSet();
        }
        return Collections.unmodifiableNavigableSet(this.entries.subSet(start2.getBound(), start2.isInclusive(), end2.getBound(), end2.isInclusive()));
    }

    public NavigableSet<ZSetEntry> entries(boolean reversed) {
        return Collections.unmodifiableNavigableSet(reversed ? this.entries.descendingSet() : this.entries);
    }

    @Override
    public void raiseTypeCastException() {
        throw new WrongValueTypeException("WRONGTYPE RMZSet value is used in the wrong place");
    }

    @Override
    public String getTypeName() {
        return "zset";
    }

    public int indexOf(Double score, Slice member) {
        return this.entries.headSet(new ZSetEntry(score, member)).size();
    }
}

