/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures.streams;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.StreamId;
import com.github.fppt.jedismock.exception.WrongStreamKeyException;
import com.github.fppt.jedismock.exception.WrongValueTypeException;

public class RMStream
implements RMDataStructure {
    private final SequencedMap<StreamId, SequencedMap<Slice, Slice>> storedData = new SequencedMap();
    private StreamId lastId = new StreamId();

    public StreamId getLastId() {
        return this.lastId;
    }

    public SequencedMap<StreamId, SequencedMap<Slice, Slice>> getStoredData() {
        return this.storedData;
    }

    public void updateLastId(StreamId id) {
        this.lastId = id;
    }

    public Slice replaceAsterisk(Slice key2) throws WrongStreamKeyException {
        if (key2.toString().equals("*")) {
            if (this.lastId.getFirstPart() == -1L && this.lastId.getSecondPart() == -1L) {
                throw new WrongStreamKeyException("ERR The stream has exhausted the last possible ID, unable to add more items");
            }
            long secondPart = this.lastId.getSecondPart() + 1L;
            long firstPart = this.lastId.getFirstPart() + (long)(this.lastId.getSecondPart() == -1L ? 1 : 0);
            return Slice.create(Long.toUnsignedString(firstPart) + "-" + Long.toUnsignedString(secondPart));
        }
        String[] parsedKey = key2.toString().split("-");
        if (parsedKey.length != 2) {
            return key2;
        }
        try {
            if (Long.compareUnsigned(this.lastId.getFirstPart(), Long.parseUnsignedLong(parsedKey[0])) > 0) {
                throw new WrongStreamKeyException("ERR The ID specified in XADD is equal or smaller than the target stream top item");
            }
            if (parsedKey[1].equals("*")) {
                if (Long.compareUnsigned(this.lastId.getFirstPart(), Long.parseUnsignedLong(parsedKey[0])) == 0) {
                    if (this.lastId.getSecondPart() == -1L) {
                        throw new WrongStreamKeyException("ERR The ID specified in XADD is equal or smaller than the target stream top item");
                    }
                    return Slice.create(parsedKey[0] + "-" + Long.toUnsignedString(this.lastId.getSecondPart() + 1L));
                }
                return Slice.create(parsedKey[0] + "-0");
            }
        }
        catch (NumberFormatException e2) {
            throw new WrongStreamKeyException("ERR Invalid stream ID specified as stream command argument");
        }
        return key2;
    }

    @Override
    public void raiseTypeCastException() {
        throw new WrongValueTypeException("WRONGTYPE RMStream value is used in the wrong place");
    }

    @Override
    public String getTypeName() {
        return "stream";
    }
}

