/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures.streams;

import com.github.fppt.jedismock.datastructures.streams.SequencedMapForwardIterator;
import com.github.fppt.jedismock.datastructures.streams.SequencedMapReverseIterator;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class SequencedMap<K extends Comparable<K>, V>
implements Iterable<Map.Entry<K, V>> {
    private final Map<K, LinkedMapNode> map = new HashMap<K, LinkedMapNode>();
    private K tail;
    private K head;
    private int size = 0;

    public void append(K key2, V value2) {
        if (this.size == 0) {
            this.head = key2;
        } else {
            this.map.get(this.tail).setNext(key2);
        }
        this.map.put(key2, new LinkedMapNode(value2).setPrev(this.tail));
        ++this.size;
        this.tail = key2;
    }

    public Map.Entry<K, V> remove(K key2) {
        if (!this.map.containsKey(key2)) {
            return null;
        }
        if (this.size == 1) {
            this.size = 0;
            this.tail = null;
            this.head = null;
            return new AbstractMap.SimpleEntry(key2, this.map.remove(key2).value);
        }
        if (key2.equals(this.tail)) {
            this.tail = this.getPreviousKey(key2);
            this.map.get(this.tail).next = null;
        } else if (key2.equals(this.head)) {
            this.head = this.getNextKey(key2);
            this.map.get(this.head).prev = null;
        } else {
            this.setNextKey(this.getPreviousKey(key2), this.getNextKey(key2));
            this.setPreviousKey(this.getNextKey(key2), this.getPreviousKey(key2));
        }
        --this.size;
        return new AbstractMap.SimpleEntry(key2, this.map.remove(key2).value);
    }

    public void removeHead() {
        if (this.size == 0) {
            return;
        }
        --this.size;
        this.head = this.getNextKey(this.head);
    }

    public V get(K key2) {
        LinkedMapNode node = this.map.get(key2);
        if (node == null) {
            return null;
        }
        return node.value;
    }

    public int size() {
        return this.size;
    }

    K getNextKey(K key2) {
        return this.map.get(key2).next;
    }

    void setNextKey(K key2, K next2) {
        if (!this.map.containsKey(next2) || !this.map.containsKey(key2)) {
            throw new NullPointerException("Map does not contain some of provided keys");
        }
        this.map.get(key2).next = next2;
    }

    public K getPreviousKey(K key2) {
        return this.map.get(key2).prev;
    }

    public void setPreviousKey(K key2, K prev) {
        if (!this.map.containsKey(prev) || !this.map.containsKey(key2)) {
            throw new NullPointerException("Map does not contain some of provided keys");
        }
        this.map.get(key2).prev = prev;
    }

    public boolean contains(K key2) {
        return this.map.containsKey(key2);
    }

    public K getHead() {
        return this.head;
    }

    public K getTail() {
        return this.tail;
    }

    public SequencedMapForwardIterator<K, V> iterator() {
        return new SequencedMapForwardIterator(this.head, this);
    }

    public SequencedMapForwardIterator<K, V> iterator(K key2) {
        if (key2 == null) {
            throw new NullPointerException("Key is null");
        }
        if (this.map.containsKey(key2)) {
            return new SequencedMapForwardIterator(key2, this);
        }
        Comparable startKey = null;
        SequencedMapForwardIterator it = new SequencedMapForwardIterator(null, this);
        if (key2 != this.head) {
            while (it.hasNext() && (startKey = (Comparable)it.next().getKey()).compareTo(key2) < 0) {
            }
        }
        if (startKey != null) {
            it.stepBack();
        }
        return it;
    }

    public SequencedMapReverseIterator<K, V> reverseIterator() {
        return new SequencedMapReverseIterator(this.tail, this);
    }

    public SequencedMapReverseIterator<K, V> reverseIterator(K key2) {
        if (key2 == null) {
            throw new NullPointerException("Key is null");
        }
        if (this.map.containsKey(key2)) {
            return new SequencedMapReverseIterator(key2, this);
        }
        Comparable startKey = null;
        SequencedMapReverseIterator it = new SequencedMapReverseIterator(null, this);
        if (key2 != this.tail) {
            while (it.hasNext() && (startKey = (Comparable)it.next().getKey()).compareTo(key2) > 0) {
            }
        }
        if (startKey != null) {
            it.stepBack();
        }
        return it;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.size == 0) {
            return;
        }
        K currKey = this.head;
        do {
            action.accept(currKey, this.map.get(currKey).value);
        } while ((currKey = this.map.get(currKey).next) != null);
    }

    protected class LinkedMapNode {
        protected final V value;
        protected K next;
        protected K prev;

        LinkedMapNode(V value2) {
            this.value = value2;
        }

        public LinkedMapNode setNext(K next2) {
            this.next = next2;
            return this;
        }

        public LinkedMapNode setPrev(K prev) {
            this.prev = prev;
            return this;
        }
    }
}

