/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures.streams;

import com.github.fppt.jedismock.datastructures.streams.SequencedMap;
import com.github.fppt.jedismock.datastructures.streams.SequencedMapIterator;
import java.util.AbstractMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class SequencedMapForwardIterator<K extends Comparable<K>, V>
implements SequencedMapIterator<K, V> {
    private K curr;
    private final SequencedMap<K, V> map;

    public SequencedMapForwardIterator(K curr, SequencedMap<K, V> map2) {
        this.map = map2;
        this.curr = curr == null ? null : map2.getPreviousKey(curr);
    }

    @Override
    public boolean hasNext() {
        if (this.curr == null) {
            return this.map.getHead() != null;
        }
        return this.map.getNextKey(this.curr) != null;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There is no elements left");
        }
        this.curr = this.curr == null ? this.map.getHead() : this.map.getNextKey(this.curr);
        return new AbstractMap.SimpleEntry<K, V>(this.curr, this.map.get(this.curr));
    }

    void stepBack() {
        this.curr = this.map.getPreviousKey(this.curr);
    }

    @Override
    public void remove() {
        if (this.curr == null) {
            throw new IllegalStateException("'next' method has not been invoked yet");
        }
        K tmp = this.map.getPreviousKey(this.curr);
        this.map.remove(this.curr);
        this.curr = tmp;
    }
}

