/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.SliceParser;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBPop
extends AbstractRedisOperation {
    protected long timeoutNanos;
    protected List<Slice> keys;
    private final Object lock;
    private final boolean isInTransaction;

    protected AbstractBPop(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
        this.isInTransaction = state.isTransactionModeOn();
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    @Override
    protected void doOptionalWork() {
        this.timeoutNanos = Utils.toNanoTimeout(this.params().get(this.params().size() - 1).toString());
        this.keys = this.params().subList(0, this.params().size() - 1);
    }

    protected abstract Slice popper(List<Slice> var1);

    protected abstract AbstractRedisOperation getSize(RedisBase var1, List<Slice> var2);

    @Override
    protected Slice response() {
        if (this.timeoutNanos < 0L) {
            throw new IllegalArgumentException("ERR timeout is negative");
        }
        Slice source2 = this.getKey(this.keys, true);
        long waitEnd = System.nanoTime() + this.timeoutNanos;
        try {
            long waitTimeNanos;
            while (source2 == null && !this.isInTransaction && (waitTimeNanos = this.timeoutNanos == 0L ? 0L : waitEnd - System.nanoTime()) >= 0L) {
                long waitMillis = waitTimeNanos / 1000000L > 1000L ? 1000L : waitTimeNanos / 1000000L;
                int waitNano = (int)(waitTimeNanos % 1000000L);
                this.lock.wait(waitMillis, waitNano);
                source2 = this.getKey(this.keys, false);
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            return Response.NULL;
        }
        if (source2 == null) {
            return Response.NULL_ARRAY;
        }
        return this.popper(Collections.singletonList(source2));
    }

    private Slice getKey(List<Slice> list, boolean checkForType) {
        for (Slice key2 : list) {
            Slice result2;
            if (!this.base().exists(key2)) continue;
            try {
                result2 = this.getSize(this.base(), Collections.singletonList(key2)).execute();
            }
            catch (WrongValueTypeException e2) {
                if (!checkForType) continue;
                throw e2;
            }
            int length = SliceParser.consumeInteger(result2.data());
            if (length <= 0) continue;
            return key2;
        }
        return null;
    }
}

