/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.streams.RMStream;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.Objects;

public abstract class AbstractRedisOperation
implements RedisOperation {
    private final RedisBase base;
    private final List<Slice> params;

    public AbstractRedisOperation(RedisBase base, List<Slice> params) {
        this.base = base;
        this.params = params;
    }

    protected void doOptionalWork() {
    }

    protected abstract Slice response();

    protected RedisBase base() {
        return this.base;
    }

    protected final List<Slice> params() {
        return this.params;
    }

    public RMList getListFromBaseOrCreateEmpty(Slice key2) {
        RMList data2 = this.base().getList(key2);
        if (data2 == null) {
            return new RMList();
        }
        return data2;
    }

    public RMSet getSetFromBaseOrCreateEmpty(Slice key2) {
        RMSet data2 = this.base().getSet(key2);
        if (data2 == null) {
            return new RMSet();
        }
        return data2;
    }

    public RMStream getStreamFromBaseOrCreateEmpty(Slice key2) {
        RMStream data2 = this.base().getStream(key2);
        return data2 == null ? new RMStream() : data2;
    }

    public RMZSet getZSetFromBaseOrCreateEmpty(Slice key2) {
        RMZSet data2 = this.base().getZSet(key2);
        if (data2 == null) {
            return new RMZSet();
        }
        return data2;
    }

    protected int minArgs() {
        return 0;
    }

    protected int maxArgs() {
        return Integer.MAX_VALUE;
    }

    protected RedisCommand self() {
        return Objects.requireNonNull(this.getClass().getAnnotation(RedisCommand.class));
    }

    @Override
    public Slice execute() {
        RedisCommand self = this.self();
        try {
            if (this.params().size() < this.minArgs() || this.params().size() > this.maxArgs()) {
                return Response.error(String.format("ERR wrong number of arguments for '%s' command", self.value()));
            }
            this.doOptionalWork();
            return this.response();
        }
        catch (IndexOutOfBoundsException e2) {
            throw new IllegalArgumentException(String.format("Received wrong number of arguments when executing command [%s]", self.value()), e2);
        }
    }
}

