/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class CommandFactory {
    private static final Map<Boolean, Map<String, Class<? extends RedisOperation>>> commands;

    public static RedisOperation buildOperation(String name, boolean transactional, OperationExecutorState state, List<Slice> params) {
        Class<? extends RedisOperation> commandClass = commands.get(transactional).get(name);
        if (commandClass != null) {
            try {
                Constructor<?> declaredConstructor = commandClass.getDeclaredConstructors()[0];
                Class<?>[] parameterTypes = declaredConstructor.getParameterTypes();
                Constructor<? extends RedisOperation> constructor = commandClass.getDeclaredConstructor(parameterTypes);
                constructor.setAccessible(true);
                Object[] parameters2 = new Object[parameterTypes.length];
                for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                    if (parameterTypes[i2].isAssignableFrom(List.class)) {
                        parameters2[i2] = params;
                        continue;
                    }
                    if (parameterTypes[i2].isAssignableFrom(OperationExecutorState.class)) {
                        parameters2[i2] = state;
                        continue;
                    }
                    if (parameterTypes[i2].isAssignableFrom(RedisBase.class)) {
                        parameters2[i2] = state.base();
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Cannot resolve parameter of type %s for command %s", parameterTypes[i2].getSimpleName(), name));
                }
                return constructor.newInstance(parameters2);
            }
            catch (ReflectiveOperationException e2) {
                throw new IllegalStateException(e2);
            }
        }
        return null;
    }

    public static void initialize() {
    }

    static {
        Reflections scanner = new Reflections(CommandFactory.class.getPackage().getName(), new Scanner[0]);
        Set<Class<RedisOperation>> redisOperations = scanner.getSubTypesOf(RedisOperation.class);
        commands = redisOperations.stream().filter(ReflectionUtils.withAnnotation(RedisCommand.class)).collect(Collectors.groupingBy(c2 -> c2.getAnnotation(RedisCommand.class).transactional(), Collectors.toMap(c2 -> c2.getAnnotation(RedisCommand.class).value(), Function.identity())));
    }
}

