/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.hashes;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.hashes.HIncrBy;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

@RedisCommand(value="hincrbyfloat")
class HIncrByFloat
extends HIncrBy {
    HIncrByFloat(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    private static void validateHIncrByFloatArgument(Slice input) {
        byte[] bts;
        String errorMessage = "ERR value is not a valid float";
        String foundValueStr = String.valueOf(input);
        if (foundValueStr.startsWith(" ") || foundValueStr.endsWith(" ")) {
            throw new IllegalArgumentException("ERR value is not a valid float");
        }
        for (byte bt : bts = input.data()) {
            if (bt != 0) continue;
            throw new IllegalArgumentException("ERR value is not a valid float");
        }
    }

    @Override
    Slice hsetValue(Slice key1, Slice key2, Slice value2) {
        double numericValue = Utils.convertToDouble(String.valueOf(value2));
        Slice foundValue = this.base().getSlice(key1, key2);
        if (foundValue != null) {
            HIncrByFloat.validateHIncrByFloatArgument(foundValue);
            numericValue = Utils.convertToDouble(new String(foundValue.data())) + numericValue;
        }
        DecimalFormatSymbols separator = new DecimalFormatSymbols(Locale.getDefault());
        separator.setDecimalSeparator('.');
        DecimalFormat formatter = new DecimalFormat("#.#################", separator);
        Slice res = Slice.create(formatter.format(numericValue));
        this.base().putSlice(key1, key2, res, -1L);
        return Response.bulkString(res);
    }

    @Override
    protected Slice response() {
        Slice key1 = this.params().get(0);
        Slice key2 = this.params().get(1);
        Slice value2 = this.params().get(2);
        return this.hsetValue(key1, key2, value2);
    }
}

