/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.hashes;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="hset")
class HSet
extends AbstractRedisOperation {
    HSet(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    Slice hsetValue(Slice key1, Slice key2, Slice value2) {
        Slice foundValue = this.base().getSlice(key1, key2);
        this.base().putSlice(key1, key2, value2, null);
        return foundValue;
    }

    @Override
    protected Slice response() {
        Slice hash = this.params().get(0);
        int count2 = 0;
        if (this.params().size() % 2 == 0) {
            throw new IllegalArgumentException("Recieved wrong number of arguments when executing command HSET");
        }
        for (int i2 = 1; i2 < this.params().size(); i2 += 2) {
            Slice value2;
            Slice field = this.params().get(i2);
            Slice oldValue = this.hsetValue(hash, field, value2 = this.params().get(i2 + 1));
            if (oldValue != null) continue;
            ++count2;
        }
        return Response.integer(count2);
    }
}

