/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.List;

@RedisCommand(value="rename")
class Rename
extends AbstractRedisOperation {
    private final Object lock;

    Rename(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    private boolean rename(Slice key2, Slice newKey) {
        RMDataStructure value2 = this.base().getValue(key2);
        Long ttl = this.base().getTTL(key2);
        if (ttl == null || value2 == null) {
            return false;
        }
        this.base().deleteValue(newKey);
        this.base().putValue(newKey, value2, ttl);
        this.base().deleteValue(key2);
        this.lock.notifyAll();
        return true;
    }

    @Override
    protected Slice response() {
        Slice newKey;
        Slice key2 = this.params().get(0);
        if (!this.rename(key2, newKey = this.params().get(1))) {
            return Response.error("ERR no such key");
        }
        return Response.OK;
    }
}

