/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.lists.LRange;
import com.github.fppt.jedismock.operations.lists.RPopLPush;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.SliceParser;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.Arrays;
import java.util.List;

@RedisCommand(value="brpoplpush")
class BRPopLPush
extends RPopLPush {
    private long count = 0L;
    private final Object lock;
    private final boolean isInTransaction;

    BRPopLPush(OperationExecutorState state, List<Slice> params) {
        super(state, params);
        this.lock = state.lock();
        this.isInTransaction = state.isTransactionModeOn();
    }

    @Override
    protected void doOptionalWork() {
        Slice source2 = this.params().get(0);
        long timeoutNanos = Utils.toNanoTimeout(this.params().get(2).toString());
        if (timeoutNanos < 0L) {
            throw new IllegalArgumentException("ERR timeout is negative");
        }
        long waitEnd = System.nanoTime() + timeoutNanos;
        this.count = this.getCount(source2);
        try {
            long waitTimeNanos;
            while (this.count == 0L && !this.isInTransaction && (waitTimeNanos = timeoutNanos == 0L ? 0L : waitEnd - System.nanoTime()) >= 0L) {
                this.lock.wait(waitTimeNanos / 1000000L, (int)waitTimeNanos % 1000000);
                this.count = this.getCount(source2);
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected Slice response() {
        if (this.count != 0L) {
            return super.response();
        }
        return Response.NULL;
    }

    private long getCount(Slice source2) {
        Slice index = Slice.create("0");
        List<Slice> commands = Arrays.asList(source2, index, index);
        Slice result2 = new LRange(this.base(), commands).execute();
        return SliceParser.consumeCount(result2.data());
    }
}

