/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@RedisCommand(value="lpos")
public class LPos
extends AbstractRedisOperation {
    private static final String RANK = "rank";
    private static final String COUNT = "count";
    private static final String MAXLEN = "maxlen";
    private int count;
    private int rank;
    private int maxLen;
    private boolean containsCount = false;

    public LPos(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key2 = this.params().get(0);
        Slice element = this.params().get(1);
        RMList list = this.getListFromBaseOrCreateEmpty(key2);
        List<Slice> storedData = list.getStoredData();
        this.parseArgs(storedData.size());
        LinkedList<Slice> result2 = new LinkedList<Slice>();
        int matches2 = 0;
        int start2 = this.rank > 0 ? 0 : storedData.size() - 1;
        int add = this.rank > 0 ? 1 : -1;
        int checkedValues = 0;
        for (int i2 = start2; i2 < storedData.size() && i2 >= 0 && this.maxLen > checkedValues; i2 += add) {
            ++checkedValues;
            if (!storedData.get(i2).equals(element) || ++matches2 < Math.abs(this.rank) || result2.size() >= this.count) continue;
            result2.add(Response.integer(i2));
        }
        if (result2.isEmpty()) {
            return Response.NULL;
        }
        return !this.containsCount ? (Slice)result2.get(0) : Response.array(result2);
    }

    private void parseArgs(int listSize) {
        Map<String, Slice> args2 = LPos.getArgsWithValues(this.params(), new HashSet<String>(Arrays.asList(RANK, COUNT, MAXLEN)));
        this.rank = Optional.ofNullable(args2.get(RANK)).map(slice -> Integer.parseInt(slice.toString())).orElse(1);
        if (this.rank == 0) {
            throw new IllegalArgumentException("ERR RANK can't be zero:");
        }
        this.count = Optional.ofNullable(args2.get(COUNT)).map(slice -> Integer.parseInt(slice.toString())).orElse(1);
        this.count = this.count == 0 ? listSize : this.count;
        this.containsCount = args2.containsKey(COUNT);
        this.maxLen = Optional.ofNullable(args2.get(MAXLEN)).map(slice -> Integer.parseInt(slice.toString())).orElse(0);
        this.maxLen = this.maxLen == 0 ? listSize : this.maxLen;
    }

    private static Map<String, Slice> getArgsWithValues(List<Slice> params, Set<String> argNames) {
        HashMap<String, Slice> argMap = new HashMap<String, Slice>();
        for (int i2 = 0; i2 < params.size(); ++i2) {
            String parameter = params.get(i2).toString().toLowerCase();
            if (!argNames.contains(parameter)) continue;
            if (++i2 == params.size()) {
                throw new IllegalArgumentException("Param " + parameter + " expected to have a value");
            }
            argMap.put(parameter, params.get(i2));
        }
        return argMap;
    }
}

